package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.datatype.model.P06B38T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (05/07/2010)
 */
public class P06B38T00DAO {
	
	static private P06B38T00DAO instance = null;

	public static P06B38T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B38T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B38T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene la lista de ramos no vida del modelo 2.2 de la DEC asociados al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de objetos de ramos no vida DEC
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B38T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B38T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B38T00Datatype();
	        	
	        	obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B38_EJERCICIO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B38_NUMEXP));
			    obj.setCodRamo(lrst.getString(P06BTablas.P06B_P06B38_CODRAMO));
			    obj.setVolTotPrimInter(lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER));
			    obj.setVolTotComisDeven(lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN));
			    obj.setVolTotHonorProf(lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B38_VOLTOT_HONORPROF));
			    obj.setNuevaPrimInter(lrst.getString(P06BTablas.P06B_P06B38_NUEVA_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B38_NUEVA_PRIMINTER));
			    obj.setNuevaComisDeven(lrst.getString(P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN));
			    obj.setNuevaHonorProf(lrst.getString(P06BTablas.P06B_P06B38_NUEVA_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B38_NUEVA_HONORPROF));
			    
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B38T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	
		
	/**
	    * Obtiene la lista de ramos no vida del modelo 2.2 de la DEC asociados al expediente y ejercicio
	    * @param ejer.
	    * @param tipoMediador          
	    * @return Lista de objetos de ramos no vida DEC
		 * @throws Exception
	    */
		public ArrayList selectAllByEjerTipoMediador(String ejer, String tipoMediador) throws Exception{
			P06BLog.send(2,this, "Inicio P06B38T00DAO-selectAllByEjerTipoMediador");
			ArrayList lista = new ArrayList();
			P06B38T00Datatype obj = null;
			PreparedStatement lstm  = null;
	        ResultSet lrst  = null;
	        String sql = SELECTALL_BY_EJEREXPTIPOMEDIADOR;
	        String tipoMediadorFmtd = tipoMediador.toUpperCase()+"-%";
	        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
	        try {
	        	lstm = lconConexion.prepareStatement(sql);
	        	lstm.setString(1,ejer);
	        	lstm.setString(2,tipoMediadorFmtd);
	        	lrst = lstm.executeQuery();
		        while (lrst.next()) {
		        	obj = new P06B38T00Datatype();
		        	
		        	obj.setEjercicio(ejer);
				    obj.setNumExp(tipoMediadorFmtd);
				    obj.setCodRamo(lrst.getString(P06BTablas.P06B_P06B38_CODRAMO));
				    obj.setVolTotPrimInter(lrst.getString(2)==null?"":lrst.getString(2));
				    obj.setVolTotComisDeven(lrst.getString(3)==null?"":lrst.getString(3));
				    obj.setVolTotHonorProf(lrst.getString(4)==null?"":lrst.getString(4));
				    obj.setNuevaPrimInter(lrst.getString(5)==null?"":lrst.getString(5));
				    obj.setNuevaComisDeven(lrst.getString(6)==null?"":lrst.getString(6));
				    obj.setNuevaHonorProf(lrst.getString(7)==null?"":lrst.getString(7));
				    
		        	lista.add(obj);
		        }
		        P06BLog.send(2,this, "Fin P06B38T00DAO-selectAllByEjerTipoMediador");
		    } catch (SQLException e) {
		    	P06BLog.send(2,this, "error: " +e.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e;
		    }catch (Exception e2) {	 
	        	P06BLog.send(2,this, "error: " +e2.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e2;
		    }finally {
		    	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		    }
			return lista;
		}
		
			
		/**
		    * Obtiene la lista de ramos no vida del modelo 2.2 de la DEC asociados al expediente y ejercicio
		    * @param ejer.
		    * @param tipoMediador          
		    * @return Lista de objetos de ramos no vida DEC
			 * @throws Exception
		    */
			public ArrayList selectAllByEjer(String ejer) throws Exception{
				P06BLog.send(2,this, "Inicio P06B38T00DAO-selectAllByEjer");
				ArrayList lista = new ArrayList();
				P06B38T00Datatype obj = null;
				PreparedStatement lstm  = null;
		        ResultSet lrst  = null;
		        String sql = SELECTALL_BY_EJER;
		        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
		        try {
		        	lstm = lconConexion.prepareStatement(sql);
		        	lstm.setString(1,ejer);
		        	lrst = lstm.executeQuery();
			        while (lrst.next()) {
			        	obj = new P06B38T00Datatype();
			        	
			        	obj.setEjercicio(ejer);
					    obj.setCodRamo(lrst.getString(P06BTablas.P06B_P06B38_CODRAMO));
					    obj.setVolTotPrimInter(lrst.getString(2)==null?"":lrst.getString(2));
					    obj.setVolTotComisDeven(lrst.getString(3)==null?"":lrst.getString(3));
					    obj.setVolTotHonorProf(lrst.getString(4)==null?"":lrst.getString(4));
					    obj.setNuevaPrimInter(lrst.getString(5)==null?"":lrst.getString(5));
					    obj.setNuevaComisDeven(lrst.getString(6)==null?"":lrst.getString(6));
					    obj.setNuevaHonorProf(lrst.getString(7)==null?"":lrst.getString(7));
					    
			        	lista.add(obj);
			        }
			        P06BLog.send(2,this, "Fin P06B38T00DAO-selectAllByEjer");
			    } catch (SQLException e) {
			    	P06BLog.send(2,this, "error: " +e.getMessage());
		        	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			        //Propago la excepcin
			        throw e;
			    }catch (Exception e2) {	 
		        	P06BLog.send(2,this, "error: " +e2.getMessage());
		        	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			        //Propago la excepcin
			        throw e2;
			    }finally {
			    	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			    }
				return lista;
			}
			
				
	/**
    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
    * @param ejerDEC.
    *            ejercicio de la DEC
    * @param objInformeDEC.
    *            objeto donde actualizar los datos obtenidos en la select
	 * @throws Exception
    */
	public void selectRamosNoVidaInformeDEC(String ejerDEC, P06BInformeDEC objInformeDEC,String tipoMed) throws Exception{
		P06BLog.send(2,this, "Inicio P06B38T00DAO-selectRamosNoVidaInformeDEC");
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_RAMOSNOVIDA_INFORMEDEC;
        
        //Dependiendo del tipo hacer una select u otra. Corredores: F, J, RF, RJ. Vinculados: AF, AJ. Operadores banca: OV.
        if(P06BConstantes.P06B_CORR.equals(tipoMed)){
        	sql += " AND " + " (" + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA+"-%' or " + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA+"-%' or " + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_JURIDICA+"-%' or " + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_FISICA+"-%')";
    	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_FISICA+"-%' or " + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA+"-%')";
    	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_VINCULADO+"-%' or " + P06BTablas.P06B_P06B38_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_EXCLUSIVO+"-%')";
    	}
        
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejerDEC.toUpperCase());
        	lrst = lstm.executeQuery();
        	
        	 if (lrst.next()) {
 	        	if(P06BConstantes.P06B_CORR.equals(tipoMed)){
 	        		objInformeDEC.setPrimInterVolTotNoVidaCorrM2(lrst.getDouble("PRIMINTER_VOLTOT_NOVIDA"));
 	 	        	objInformeDEC.setComisVolTotNoVidaCorrM2(lrst.getDouble("COMISDEVEN_VOLTOT_NOVIDA"));
 	 	        	objInformeDEC.setPrimInterNuevaNoVidaCorrM2(lrst.getDouble("PRIMINTER_NUEVAPROD_NOVIDA"));
	 	       	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
		 	       	objInformeDEC.setPrimInterVolTotNoVidaVincM2(lrst.getDouble("PRIMINTER_VOLTOT_NOVIDA"));
	 	        	objInformeDEC.setComisVolTotNoVidaVincM2(lrst.getDouble("COMISDEVEN_VOLTOT_NOVIDA"));
	 	        	objInformeDEC.setPrimInterNuevaNoVidaVincM2(lrst.getDouble("PRIMINTER_NUEVAPROD_NOVIDA"));
	 	       	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
		 	       	objInformeDEC.setPrimInterVolTotNoVidaObsM2(lrst.getDouble("PRIMINTER_VOLTOT_NOVIDA"));
	 	        	objInformeDEC.setComisVolTotNoVidaObsM2(lrst.getDouble("COMISDEVEN_VOLTOT_NOVIDA"));
	 	        	objInformeDEC.setPrimInterNuevaNoVidaObsM2(lrst.getDouble("PRIMINTER_NUEVAPROD_NOVIDA"));
	 	       	}
	        }
	        P06BLog.send(2,this, "Fin P06B38T00DAO-selectRamosNoVidaInformeDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
	}
	
	
	/**
	    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
	    * @param ejerDEC.
	    *            ejercicio de la DEC
	    * @param objInformeDEC.
	    *            objeto donde actualizar los datos obtenidos en la select
		 * @throws Exception
	    */
		public void selectDatosInformeOtroDEC(String ejerDEC, P06BInformeOtroDEC objInformeOtroDEC) throws Exception{
			P06BLog.send(2,this, "Inicio P06B38T00DAO-selectDatosInformeOtroDEC");
			PreparedStatement lstm  = null;
	        ResultSet lrst  = null;
	        String sql = SELECT_DATOS_INFORMEOTRODEC;
	        String sTipoMediador;
	        
	        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
	        try {
	        	lstm = lconConexion.prepareStatement(sql);
	        	lstm.setString(1,ejerDEC.toUpperCase());
	        	lrst = lstm.executeQuery();
	        	
	        	 while (lrst.next()) {
		        		sTipoMediador = lrst.getString("TC");
			        	if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_FISICA)){
			        		objInformeOtroDEC.setD38_F1(lrst.getDouble("D1"));
			        		objInformeOtroDEC.setD38_F2(lrst.getDouble("D2"));
			        		objInformeOtroDEC.setD38_F3(lrst.getDouble("D3"));
			        		objInformeOtroDEC.setD38_F4(lrst.getDouble("D4"));
			        		objInformeOtroDEC.setD38_F5(lrst.getDouble("D5"));
			        		objInformeOtroDEC.setD38_F6(lrst.getDouble("D6"));
			        	}else if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_JURIDICA)){
			        		objInformeOtroDEC.setD38_J1(lrst.getDouble("D1"));
			        		objInformeOtroDEC.setD38_J2(lrst.getDouble("D2"));
			        		objInformeOtroDEC.setD38_J3(lrst.getDouble("D3"));
			        		objInformeOtroDEC.setD38_J4(lrst.getDouble("D4"));
			        		objInformeOtroDEC.setD38_J5(lrst.getDouble("D5"));
			        		objInformeOtroDEC.setD38_J6(lrst.getDouble("D6"));
			        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_FISICA)){
			        		objInformeOtroDEC.setD38_AF1(lrst.getDouble("D1"));
			        		objInformeOtroDEC.setD38_AF2(lrst.getDouble("D2"));
			        		objInformeOtroDEC.setD38_AF3(lrst.getDouble("D3"));
			        		objInformeOtroDEC.setD38_AF4(lrst.getDouble("D4"));
			        		objInformeOtroDEC.setD38_AF5(lrst.getDouble("D5"));
			        		objInformeOtroDEC.setD38_AF6(lrst.getDouble("D6"));
			        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_JURIDICA)){
			        		objInformeOtroDEC.setD38_AJ1(lrst.getDouble("D1"));
			        		objInformeOtroDEC.setD38_AJ2(lrst.getDouble("D2"));
			        		objInformeOtroDEC.setD38_AJ3(lrst.getDouble("D3"));
			        		objInformeOtroDEC.setD38_AJ4(lrst.getDouble("D4"));
			        		objInformeOtroDEC.setD38_AJ5(lrst.getDouble("D5"));
			        		objInformeOtroDEC.setD38_AJ6(lrst.getDouble("D6"));
			        	}
		        }
		        P06BLog.send(2,this, "Fin P06B38T00DAO-selectDatosInformeOtroDEC");
		    } catch (SQLException e) {
		    	P06BLog.send(2,this, "error: " +e.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e;
		    }catch (Exception e2) {	 
	        	P06BLog.send(2,this, "error: " +e2.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e2;
		    }finally {
		    	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		    }
		}
		
		
	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B38_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B38_NUMEXP + ", "
		+ P06BTablas.P06B_P06B38_CODRAMO + ", "
		+ P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER + ", "
		+ P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN + ", "
		+ P06BTablas.P06B_P06B38_VOLTOT_HONORPROF + ", "
		+ P06BTablas.P06B_P06B38_NUEVA_PRIMINTER + ", "
		+ P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN + ", "
		+ P06BTablas.P06B_P06B38_NUEVA_HONORPROF +
		" FROM " + P06BTablas.P06B_P06B38T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B38_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B38_NUMEXP + "= ?"
		+" ORDER BY TO_NUMBER(" + P06BTablas.P06B_P06B38_CODRAMO + ")" ;
	
	
	private static String SELECTALL_BY_EJEREXPTIPOMEDIADOR =
		"SELECT "
		+ P06BTablas.P06B_P06B38_CODRAMO + ", "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_HONORPROF + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_PRIMINTER + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_HONORPROF + ") "
		+ " FROM " + P06BTablas.P06B_P06B38T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B38_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B38_NUMEXP + " LIKE ?"
		+ " GROUP BY " + P06BTablas.P06B_P06B38_CODRAMO
		+ " ORDER BY TO_NUMBER(" + P06BTablas.P06B_P06B38_CODRAMO + ")" ;
	
	
	private static String SELECTALL_BY_EJER =
		"SELECT "
		+ P06BTablas.P06B_P06B38_CODRAMO + ", "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_VOLTOT_HONORPROF + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_PRIMINTER + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN + "), "
		+ "SUM("
		+ P06BTablas.P06B_P06B38_NUEVA_HONORPROF + ") "
		+ " FROM " + P06BTablas.P06B_P06B38T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B38_EJERCICIO + "= ?" 
		+ " GROUP BY " + P06BTablas.P06B_P06B38_CODRAMO
		+ " ORDER BY TO_NUMBER(" + P06BTablas.P06B_P06B38_CODRAMO + ")" ;
	
	
	private static String SELECT_RAMOSNOVIDA_INFORMEDEC =
		"SELECT sum(nvl("+P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER+",0)) as PRIMINTER_VOLTOT_NOVIDA,"+
		" sum(nvl("+P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN+",0)) as COMISDEVEN_VOLTOT_NOVIDA,"+
		" sum(nvl("+P06BTablas.P06B_P06B38_NUEVA_PRIMINTER+",0)) as PRIMINTER_NUEVAPROD_NOVIDA"+
		" FROM " + P06BTablas.P06B_P06B38T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B38_EJERCICIO + "= ?";
	
	private static String SELECT_DATOS_INFORMEOTRODEC =
		"SELECT SUBSTR(" + P06BTablas.P06B_P06B38_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B38_NUMEXP + ", '-')-1) as TC, SUM(NVL(" +
		P06BTablas.P06B_P06B38_VOLTOT_PRIMINTER + ",0)) as D1, SUM(NVL(" +
		P06BTablas.P06B_P06B38_VOLTOT_COMISDEVEN + ",0)) as D2, SUM(NVL(" +
		P06BTablas.P06B_P06B38_VOLTOT_HONORPROF + ",0)) as D3, SUM(NVL(" +
		P06BTablas.P06B_P06B38_NUEVA_PRIMINTER + ",0)) as D4, SUM(NVL(" +
		P06BTablas.P06B_P06B38_NUEVA_COMISDEVEN + ",0)) as D5, SUM(NVL(" +
		P06BTablas.P06B_P06B38_NUEVA_HONORPROF + ",0)) as D6 FROM " +
		P06BTablas.P06B_P06B38T00_TABLA + " WHERE " + P06BTablas.P06B_P06B38_EJERCICIO + " = ? GROUP BY SUBSTR(" + P06BTablas.P06B_P06B38_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B38_NUMEXP + ", '-')-1)";
	
}
